/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.network.PacketGetListFromServer;
import mcjty.lib.network.PacketSendServerCommand;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolscontrol.CommandHandler;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.network.PacketGetLog;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOp;
import mcjty.rftoolscontrol.setup.RFToolsCtrlMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ProcessorRenderer
implements BlockEntityRenderer<ProcessorTileEntity> {
    public ProcessorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ProcessorTileEntity te, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.getShowHud() == 0) {
            return;
        }
        BlockState state = te.m_58904_().m_8055_(te.m_58899_());
        Block block = state.m_60734_();
        if (!(block instanceof BaseBlock)) {
            return;
        }
        BaseBlock baseBlock = (BaseBlock)block;
        matrixStack.m_85836_();
        Direction facing = BaseBlock.getFrontDirection((RotationType)baseBlock.getRotationType(), (BlockState)state);
        matrixStack.m_85837_(0.5, 1.5, 0.5);
        if (facing == Direction.UP) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
        } else if (facing == Direction.DOWN) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        } else {
            float rotY = switch (facing) {
                case Direction.NORTH -> 180.0f;
                case Direction.WEST -> 90.0f;
                case Direction.EAST -> -90.0f;
                default -> 0.0f;
            };
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-rotY));
        }
        if (te.m_58904_().m_46859_(te.m_58899_().m_7494_())) {
            matrixStack.m_85837_(0.0, 0.0, -0.03749999403953552);
        } else {
            matrixStack.m_85837_(0.0, 0.0, 0.4624999761581421);
        }
        this.renderHud(matrixStack, buffer, Minecraft.m_91087_().f_91062_, te);
        matrixStack.m_85849_();
    }

    private void renderHud(PoseStack matrixStack, MultiBufferSource buffer, Font fontrenderer, ProcessorTileEntity tileEntity) {
        float factor = 1.0f;
        int currenty = 7;
        matrixStack.m_85837_(-0.5, 0.5, (double)0.07f);
        float f3 = 0.0075f;
        matrixStack.m_85841_(f3 * factor, -f3 * factor, f3);
        if (tileEntity.getShowHud() == 3) {
            this.renderGfx(matrixStack, buffer, tileEntity);
        } else {
            this.renderLog(matrixStack, buffer, fontrenderer, tileEntity, currenty);
        }
    }

    private void renderLog(PoseStack matrixStack, MultiBufferSource buffer, Font fontrenderer, ProcessorTileEntity tileEntity, int currenty) {
        List<String> log = tileEntity.getShowHud() == 2 ? tileEntity.getClientDebugLog() : tileEntity.getClientLog();
        long t = System.currentTimeMillis();
        if (t - tileEntity.clientTime > 250L) {
            if (tileEntity.getShowHud() == 2) {
                RFToolsCtrlMessages.INSTANCE.sendToServer((Object)new PacketGetListFromServer(tileEntity.m_58899_(), ProcessorTileEntity.CMD_GETDEBUGLOG.name()));
            } else {
                RFToolsCtrlMessages.INSTANCE.sendToServer((Object)new PacketGetLog(tileEntity.getDimension(), tileEntity.m_58899_(), false));
            }
            tileEntity.clientTime = t;
        }
        int height = 10;
        int logsize = log.size();
        int i = 0;
        for (String s : log) {
            if (i >= logsize - 11 && currenty + height <= 124) {
                fontrenderer.m_92811_(fontrenderer.m_92834_(s, 115), 7.0f, (float)currenty, -1, false, matrixStack.m_85850_().m_85861_(), buffer, false, 0, 0xF000F0);
                currenty += height;
            }
            ++i;
        }
    }

    private void renderGfx(PoseStack matrixStack, MultiBufferSource buffer, ProcessorTileEntity tileEntity) {
        List<GfxOp> ops;
        long t = System.currentTimeMillis();
        if (t - tileEntity.clientTime > 250L) {
            RFToolsCtrlMessages.INSTANCE.sendToServer((Object)new PacketSendServerCommand("rftoolscontrol", "getGraphics", TypedMap.builder().put(CommandHandler.PARAM_POS, (Object)tileEntity.m_58899_()).build()));
            tileEntity.clientTime = t;
        }
        if ((ops = tileEntity.getClientGfxOps()) != null) {
            for (GfxOp op : ops) {
                op.render(matrixStack, buffer);
            }
        }
    }

    public static void register() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ProcessorModule.PROCESSOR_TILE.get()), ProcessorRenderer::new);
    }
}

